#import "@preview/cetz:0.4.2"
#import "@preview/codly:1.3.0": codly, codly-init, no-codly
#import "@preview/codly-languages:0.1.8": codly-languages
#import "@preview/curryst:0.5.1": prooftree, rule
#import "@preview/fletcher:0.5.7"
#import "@preview/touying:0.6.1": (
  alternatives, appendix, config-common, config-info, meanwhile, only, pause,
  themes, touying-reducer, uncover, utils,
)

#import themes.metropolis: metropolis-theme, slide, title-slide

#set text(lang: "en", font: "Fira Sans", weight: "light", fallback: false)
#set par(justify: true)
#set strong(delta: 100)
#set heading(numbering: none)
#show math.equation: set text(font: "Fira Math")

#show: codly-init.with()
#codly(languages: codly-languages, annotation-format: none)
#set raw(lang: "typst")

#let types = (
  "int",
  "float",
  "stroke",
  "str",
  "label",
  "content",
  "function",
  "type",
  "array",
  "regex",
  "dictionary",
  "arguments",
  "none",
  "bool",
  "datetime",
  "color",
  "auto",
  "tiling",
  "gradient",
  "length",
  "stroke",
  "relative",
  "direction",
  "fraction",
  "alignment",
  "any",
  "context",
  "counter",
)
#show raw.where(lang: "typst", block: false): body => {
  show regex(types.join("|")): set text(fill: rgb("#D12100"))
  body
}

#let typst-slide(pre: [], body) = box[
  #set text(fill: black)

  #pre

  #v(1fr)

  ==== Source code

  #body

  #v(1fr)

  #line(length: 100%)

  #v(1fr)

  ==== Generated PDF

  #box(stroke: 1pt + black, inset: 10pt, radius: 5pt, width: 100%, eval(
    mode: "markup",
    body.text,
  ))

  #v(1fr)
]

#let typst-grid(cols: (1fr, 1fr), body) = grid(
  columns: cols,
  column-gutter: 15pt,
  body,
  box(stroke: 1pt + black, inset: 10pt, radius: 5pt, width: 100%, eval(
    mode: "markup",
    body.text,
  )),
)


#let if-auto(x, default) = {
  if x == auto { default } else { x }
}

#let as-pair(elt) = {
  if type(elt) == array { elt } else { (elt, none) }
}

#let default-stroke = 0.5pt

#let wave(
  period: 5pt,
  amplitude: 0.5pt,
  stroke: default-stroke,
  offset: auto,
  multiple: (),
  width: auto,
  phase: 0,
  nperiods: 2,
  tiling-height: 100pt,
) = {
  let stroke = if type(stroke) == color { default-stroke + stroke } else {
    std.stroke(stroke)
  }
  let offset = if-auto(offset, stroke.thickness / 2 + amplitude)

  let pattern = tiling(
    size: (period * nperiods, tiling-height),
    relative: "self",
    {
      let s = period / period.pt() // x-unit
      let omega = 2 * calc.pi / period.pt() // omega = 2 pi f, angular frequency
      let subdiv = 4
      let x-range = nperiods * int(period.pt())
      let xs = range(x-range * subdiv + int(subdiv / 2)).map(x => x / subdiv)

      let x-values = xs.map(x => x * s)
      let y-values = xs.map(x => amplitude * calc.sin(omega * x + phase))

      let wavy-curve = curve(
        curve.move((x-values.at(0), y-values.at(1))),
        ..x-values.zip(y-values, exact: true).map(curve.line),
      )
      set curve(fill: none, stroke: stroke)
      place(dy: offset, wavy-curve)
      for (stroke-offset, repeat-stroke) in multiple.map(as-pair) {
        set curve(stroke: repeat-stroke) if repeat-stroke != none
        place(dy: offset + stroke-offset, wavy-curve)
      }
    },
  )

  if width == auto or (width != none and width != false) {
    if width == auto {
      let max-yoffset = (
        offset + calc.max(..(0pt,) + multiple.map(x => as-pair(x).at(0)))
      )
      let stroke-width = 2 * max-yoffset + 2 * amplitude + 2 * stroke.thickness
      stroke-width + pattern
    } else {
      width + pattern
    }
  } else {
    pattern
  }
}


#show: metropolis-theme.with(aspect-ratio: "16-9", config-info(
  title: [Introduction to Typst],
  subtitle: [Or what could have been TeX if it was created in the 2020s],
  author: [#smallcaps[Balthazar Patiachvili]],
  date: [#datetime.today().display()],
))

#title-slide()

= Introduction

== Context

=== What is typst ?

#quote(attribution: [About section in typst's git repository], block: true)[
  Typst#footnote(link("https://typst.app/")) is a new markup-based typesetting system that is designed to be as powerful as LaTeX while being much easier to learn and use.
]

#pagebreak()

=== Details

- Typst: name of the compiler and of the associated language

#pause

- FOSS compiler (APACHE-2.0)

#pause

- Closed source collaborative web app (main source of fundings)

#pause

- First public beta: 21/03/2023

#pause

- Several universities and (at least) one journal (IJIMAI) have official templates

#pagebreak()

=== Features

- Human-understandable error messages #footnote[No "`Missing number, treated as 0`" nor "`overfull hbox`"]

#pause

- Simple syntax

#pause

- Very good online documentation: #link("https://typst.app/docs/")

#pause

- Very fast incremental compilation

#pause

- Typed script system integrated to the language

#pause

- Outputs PDF, HTML (still in development) and images (SVG and PNG)

= Bases of typst

== Basic text

#typst-slide(
  ```typst
  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
  eiusmod tempor incididunt ut labore et dolore magnam aliquam quaerat
  voluptatem.
  ```,
)

== Titles, bold and italic

#slide(title: [Titles, bold and italic])[
  #typst-slide(
    ```typst
    = With a title

    == And a subtitle

    *Bold* text, even in _italic_, and why not _*both at the same time*_?
    ```,
  )
]

== Lists and enumerations

#typst-slide(
  ```typst
  - This is a bullet list
  - A sublist:
    + Apple
    + Banana
  - This is the last point
  ```,
)

== Images

#typst-slide(
  ```typst
  #align(center)[
    #image("./assets/velus.png", width: 70%)
  ]
  ```,
)

== Figures

#typst-slide(
  ```typst
  #figure(
    image("./assets/velus.png", width: 50%),
    caption: [Vélus logo],
  )
  ```,
)

== References

#slide(title: [References])[
  #typst-slide(
    ```typst
    #set heading(numbering: "1.1.1.", supplement: [Big title])

    = Titre <titre>
    #figure(image("./assets/latex.svg", width: 50pt),
            caption: [LaTeX logo]) <latex>
    Reference to @titre and to @latex.
    ```,
  )
]

== Bibliography

#grid(
  columns: (3fr, 1fr),
  column-gutter: 15pt,
  typst-slide(
    ```typst
    We use the bibliography defined in
    @coq-waterproof.

    #bibliography("works.bib", style: "ieee")
    ```,
  ),
  text(size: 10pt, raw(lang: "bib", read("works.bib"))),
)

== Maths

#typst-slide(
  ```typst
  Typst handles inline equations like
  $sum_(i=0)^n i = (i times (i+1))/2$, and those in blocks:
  $
    "Maxwell-Gauss formula" :
    accent(nabla, ->) dot accent(E, ->) = rho / epsilon_0
      <=> "div" accent(E, ->) = rho / epsilon_0
  $
  ```,
)

= Formatting

== Change text font

#typst-slide(
  ```typst
  #text(font: "New Computer Modern")[
    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
    temport incididunt ut labore et dolre magnam aliquam quaerat voluptatem.
  ]

  #text(font: "Noto Sans", lorem(20))
  ```,
)

== Set rules

#typst-slide(
  ```typst
  #set text(font: "New Computer Modern", size: 12pt)
  #set par(justify: true)

  #lorem(65)
  ```,
)

#pagebreak()

#slide(title: [Set rules])[
  #set text(size: 15pt)

  #typst-slide(
    pre: counter(heading).update(0),
    ```typst
    #set heading(numbering: "A.1)")

    = Part title
    == Foo
    == Bar
    = Baz
    == Boo
    ```,
  )
]

== Show rules

#typst-slide(
  ```typst
  #show "is": set text(fill: red)
  #show "LaTeX": box(image("assets/latex.svg", height: .9em), baseline: 25%)
  #show regex("(it)|([W|w]i)"): word => text(fill: blue, word.text.rev())

  With this change, every "is" is shown in red because it is the color that
  has been defined. Furthermore it is possible to make the LaTeX command
  that show the LaTeX logo, but without command!
  ```,
)

= Showcases (with packages)

== `cetz`, spiritual successor of tikz

#{
  import "@preview/cetz:0.4.2"
  set align(center)

  show math.equation: block.with(fill: white, inset: 1pt)

  cetz.canvas(length: 3cm, {
    import cetz.draw: *

    set-style(
      mark: (fill: black, scale: 2),
      stroke: (thickness: 0.4pt, cap: "round"),
      angle: (
        radius: 0.3,
        label-radius: .22,
        fill: green.lighten(80%),
        stroke: (paint: green.darken(50%)),
      ),
      content: (padding: 1pt),
    )

    grid(
      (-1.5, -1.5),
      (1.4, 1.4),
      step: 0.5,
      stroke: gray + 0.2pt,
    )

    circle((0, 0), radius: 1)

    line((-1.5, 0), (1.5, 0), mark: (end: "stealth"))
    content((), $ x $, anchor: "west")
    line((0, -1.5), (0, 1.5), mark: (end: "stealth"))
    content((), $ y $, anchor: "south")

    for (x, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (1, $ 1 $)) {
      line((x, 3pt), (x, -3pt))
      content((), anchor: "north", ct)
    }

    for (y, ct) in (
      (-1, $ -1 $),
      (-0.5, $ -1/2 $),
      (0.5, $ 1/2 $),
      (1, $ 1 $),
    ) {
      line((3pt, y), (-3pt, y))
      content((), anchor: "east", ct)
    }

    // Draw the green angle
    cetz.angle.angle((0, 0), (1, 0), (1, calc.tan(30deg)), label: text(
      green,
      [#sym.alpha],
    ))

    line((0, 0), (1, calc.tan(30deg)))

    set-style(stroke: (thickness: 1.2pt))

    line((30deg, 1), ((), "|-", (0, 0)), stroke: (paint: red), name: "sin")
    content(("sin.start", 50%, "sin.end"), text(red)[$ sin alpha $])
    line("sin.end", (0, 0), stroke: (paint: blue), name: "cos")
    content(
      ("cos.start", 50%, "cos.end"),
      text(blue)[$ cos alpha $],
      anchor: "north",
    )
    line((1, 0), (1, calc.tan(30deg)), name: "tan", stroke: (paint: orange))
    content(
      "tan.end",
      $
        text(#orange, tan alpha) = text(#red, sin alpha) / text(#blue, cos alpha)
      $,
      anchor: "west",
    )
  })
}

#pagebreak()

#{
  codly(
    ranges: ((1, 4), (18, 25), (48, 48)),
    skips: ((5, 0), (22, 10), (48, 0)),
  )
  show raw: set text(size: 13.5pt)
  ```typst
  #import "@preview/cetz:0.4.2"
  #show math.equation: block.with(fill: white, inset: 1pt)
  #cetz.canvas(length: 3cm, {
    import cetz.draw: *

    set-style(
      mark: (fill: black, scale: 2),
      stroke: (thickness: 0.4pt, cap: "round"),
      angle: (
        radius: 0.3,
        label-radius: .22,
        fill: green.lighten(80%),
        stroke: (paint: green.darken(50%))
      ),
      content: (padding: 1pt)
    )

    grid((-1.5, -1.5), (1.4, 1.4), step: 0.5, stroke: gray + 0.2pt)
    circle((0,0), radius: 1)
    line((-1.5, 0), (1.5, 0), mark: (end: "stealth"))
    content((), $ x $, anchor: "west")
    for (x, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (1, $ 1 $)) {
      line((x, 3pt), (x, -3pt))
      content((), anchor: "north", ct)
    }
    line((0, -1.5), (0, 1.5), mark: (end: "stealth"))
    content((), $ y $, anchor: "south")

    for (y, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (0.5, $ 1/2 $), (1, $ 1 $)) {
      line((3pt, y), (-3pt, y))
      content((), anchor: "east", ct)
    }

    // Draw the green angle
    cetz.angle.angle((0,0), (1,0), (1, calc.tan(30deg)),
      label: text(green, [#sym.alpha]))

    line((0,0), (1, calc.tan(30deg)))

    set-style(stroke: (thickness: 1.2pt))

    line((30deg, 1), ((), "|-", (0,0)), stroke: (paint: red), name: "sin")
    content(("sin.start", 50%, "sin.end"), text(red)[$ sin alpha $])
    line("sin.end", (0,0), stroke: (paint: blue), name: "cos")
    content(("cos.start", 50%, "cos.end"), text(blue)[$ cos alpha $], anchor: "north")
    line((1, 0), (1, calc.tan(30deg)), name: "tan", stroke: (paint: orange))
    content("tan.end", $ text(#orange, tan alpha) = text(#red, sin alpha) / text(#blue, cos alpha) $, anchor: "west")
  })
  ```
}

#pagebreak()

#align(center, scale(250%, {
  import "@preview/cetz:0.4.2": canvas, draw, matrix, vector
  canvas({
    import draw: *

    ortho(y: -30deg, x: 30deg, {
      on-xz({
        grid(
          (0, -2),
          (8, 2),
          stroke: gray + .5pt,
        )
      })

      // Draw a sine wave on the xy plane
      let wave(amplitude: 1, fill: none, phases: 2, scale: 8, samples: 100) = {
        line(
          ..(
            for x in range(0, samples + 1) {
              let x = x / samples
              let p = (2 * phases * calc.pi) * x
              ((x * scale, calc.sin(p) * amplitude),)
            }
          ),
          fill: fill,
        )

        let subdivs = 8
        for phase in range(0, phases) {
          let x = phase / phases
          for div in range(1, subdivs + 1) {
            let p = 2 * calc.pi * (div / subdivs)
            let y = calc.sin(p) * amplitude
            let x = x * scale + div / subdivs * scale / phases
            line((x, 0), (x, y), stroke: rgb(0, 0, 0, 150) + .5pt)
          }
        }
      }

      on-xy({
        wave(amplitude: 1.6, fill: rgb(0, 0, 255, 50))
      })
      on-xz({
        wave(amplitude: 1, fill: rgb(255, 0, 0, 50))
      })
    })
  })
}))

== `codly`, improved code blocks

=== Without codly

#no-codly(
  ```typst
  #import "@preview/cetz:0.4.2"
  #show math.equation: block.with(fill: white, inset: 1pt)
  #cetz.canvas(length: 3cm, {
    import cetz.draw: *
    // ...
    grid((-1.5, -1.5), (1.4, 1.4), step: 0.5, stroke: gray + 0.2pt)
    circle((0,0), radius: 1)
    line((-1.5, 0), (1.5, 0), mark: (end: "stealth"))
    content((), $ x $, anchor: "west")
    // ...
    for (x, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (1, $ 1 $)) {
      line((x, 3pt), (x, -3pt))
      content((), anchor: "north", ct)
    }
    // ...
  })
  ```,
)

#pagebreak()

=== With codly

#{
  codly(
    ranges: ((1, 4), (18, 25), (48, 48)),
    skips: ((5, 0), (22, 10), (48, 0)),
  )
  show raw: set text(size: 12.7pt)
  ```typst
  #import "@preview/cetz:0.4.2"
  #show math.equation: block.with(fill: white, inset: 1pt)
  #cetz.canvas(length: 3cm, {
    import cetz.draw: *

    set-style(
      mark: (fill: black, scale: 2),
      stroke: (thickness: 0.4pt, cap: "round"),
      angle: (
        radius: 0.3,
        label-radius: .22,
        fill: green.lighten(80%),
        stroke: (paint: green.darken(50%))
      ),
      content: (padding: 1pt)
    )

    grid((-1.5, -1.5), (1.4, 1.4), step: 0.5, stroke: gray + 0.2pt)
    circle((0,0), radius: 1)
    line((-1.5, 0), (1.5, 0), mark: (end: "stealth"))
    content((), $ x $, anchor: "west")
    for (x, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (1, $ 1 $)) {
      line((x, 3pt), (x, -3pt))
      content((), anchor: "north", ct)
    }
    line((0, -1.5), (0, 1.5), mark: (end: "stealth"))
    content((), $ y $, anchor: "south")

    for (y, ct) in ((-1, $ -1 $), (-0.5, $ -1/2 $), (0.5, $ 1/2 $), (1, $ 1 $)) {
      line((3pt, y), (-3pt, y))
      content((), anchor: "east", ct)
    }

    // Draw the green angle
    cetz.angle.angle((0,0), (1,0), (1, calc.tan(30deg)),
      label: text(green, [#sym.alpha]))

    line((0,0), (1, calc.tan(30deg)))

    set-style(stroke: (thickness: 1.2pt))

    line((30deg, 1), ((), "|-", (0,0)), stroke: (paint: red), name: "sin")
    content(("sin.start", 50%, "sin.end"), text(red)[$ sin alpha $])
    line("sin.end", (0,0), stroke: (paint: blue), name: "cos")
    content(("cos.start", 50%, "cos.end"), text(blue)[$ cos alpha $], anchor: "north")
    line((1, 0), (1, calc.tan(30deg)), name: "tan", stroke: (paint: orange))
    content("tan.end", $ text(#orange, tan alpha) = text(#red, sin alpha) / text(#blue, cos alpha) $, anchor: "west")
  })
  ```
}

== More packages

=== `curryst`, easy trees of inference rules

#{
  show raw: set text(size: 15pt)
  typst-grid(cols: (2fr, 1fr), ```typst
  #import "@preview/curryst:0.6.0": *
  #prooftree(
    rule(
      name: $R$,
      rule(
        name: $A$,
        rule($Pi_1$, $C_1 or L$),
        $C_1 or C_2 or L$,
      ),
      rule($Pi_2$, $C_2 or overline(L)$,),
      $C_1 or C_2 or C_3$,
    )
  )
  ```)
}

#pagebreak()

=== `finite`, finite automatons (use `cetz`)

#{
  show raw: set text(size: 15pt)
  typst-grid(cols: (2fr, 1fr), ```typst
  #import "@preview/finite:0.5.0": *
  #automaton((
    q0: (q1:0, q0:"0,1"),
    q1: (q0:(0,1), q2:"0"),
    q2: (),
  ))
  ```)
}

#pagebreak()

=== `touying`, beamer-like presentation

_Insert a recursive call to this presentation_


= Functions, types and scripts

== Syntactic modes

There are 3 syntactic modes in typst:

- "markup" : default mode or delimited by `[..]`
- "math" : mode of equations, delimited by `$..$`
- "code" : script mode, on blocks prefixed by `#..`, or delimited by `{..}`

#pagebreak()

#typst-slide(
  ```typst
  - Hello world:  1 + 2 = 3       // Markup
  - $pi approx 3.1415, 1 + 2 = 3$ // Math
  - #calc.pow(2, 3) = 8           // Code and markup
  - #{                            // Code block
      let res = 1 + 2
      [#res = 3]                  // Markup block
    }
  ```,
)

== Variables and functions

#typst-slide(
  pre: [
    === `let` binding
  ],
  ```typst
  #let name = "typst"
  This is a presentation on #name. \
  This is a slide on variables and functions in #name.

  #let add(x, y) = x + y
  Result of $1 + 2 = #add(1, 2)$
  ```,
)

== Scripting

=== Example

#typst-grid(cols: (2fr, 1fr), ```typst
#let fact(n) = {
  if n <= 1 {
    1
  } else {
    n * fact(n - 1)
  }
}
#for nb in range(6) [
  $nb ! = fact(nb)$
  #linebreak()
]
```)

#pagebreak()

=== typst is call-by-name

#typst-grid(cols: (2fr, 1fr), ```typst
#let foo(code) = {
  code
  [ ]
  code
}

#let bar = counter("bar")
#bar.update(0)
#foo({
  bar.step()
  context { bar.display() }
})
```)

== Types in typst

Goal: having typed arguments for functions

#pause

=== Usual types

#pause

#table(
  columns: (1fr, 2fr),
  align: center,
  table.header([*Type*], [*Examples*]),
  `int`, `0, 1, -1, ...`,
  pause, `str`,
  ```txt "This is a string"```, pause,
  `bool`, `true, false`,
  pause, `float`,
  `3.14, 1e4, 3e-3, -0.1, ...`, pause,
  `array`, `(1, 2, "trois", (4, 5))`,
  pause, `dictionary`,
  `(foo: 1, bar: "two", baz: (3, 4))`, pause,
  `none`, `none`,
  pause, `function`,
  `x => x + 1`, pause,
  `type`, `int, float, str, ..., type`,
  pause, `any`,
  [Everything above and below],
)

#pause

It is planned to improve the type system (type anotation support, types ```c struct```, ...).

#pagebreak()

== `content`, what can be displayed

#typst-slide(
  pre: [
    `content` is the type of what can be displayed on a document.
    #pause
  ],
  ```typ
  The type of "*Hello world!*" is :
  #type([*Hello world!*])

  Furthermore, the type of an image is:
  #type(image("./assets/velus.png"))
  ```,
)

#pagebreak()

- `content` is the most important type in `typst`: it is the type of the default context.

#pause

- Automatic coercion to this type (almost always) when needed.

#typst-grid(
  ```typst
  #let name = "Typst"
  This variable "#name" is a
  `str` in the middle of `content`.
  ```,
)

#pause

- "Final" type: very few operations are available to manipulate it.

== Types atypiques (non-exhaustive)

#table(
  columns: (1fr, 2fr, 1.2fr),
  align: (center, left, center),
  table.header([*Type*], [*Description*], [*Examples*]),
  `auto`, [Default value of an argument], [`auto` ],
  `label`, [Label of an other element], [`<exemple>` ],
  `length`, [A size or a length (with a unit)], [`20pt`, `2cm` ],
  `relative`, [A relative length to another], [`25%`, `50% + 1cm` ],
  `fraction`, [Fraction of the available space], [See the table example ],
  `alignment`, [Where to align content on an axis], [`left`, `center` ],
  `color`, [Colors (RGB, CMYK, ...)], [`#rgb("#fe30aa")`, `#red` ],
  `stroke`, [How to draw a line], [See the table example ],
  `counter`, [Counters of pages, headings, ...], [`#counter(heading)` ],
  `arguments`, [Arguments of a function], [See the documentation ],
  `regex`, [Regular expression], [`#regex("[a-zA-Z]+")` ],
  `gradient`, [A gradient of colors], [See the documentation ],
  `datetime`, [A date, an hour or both], [`#today()` ],
  `tiling`, [A periodic pavage], [See the documentation ],
  `direction`, [Direction of the content], [`ltr`, `ttb`],
)

#pagebreak()

== Promised example of the table

#{
  show raw: set text(size: 13pt)

  typst-slide(
    ```typst
    #table(                                              // Type of expressions:
      columns: (1fr, 2fr),                               // array of fraction
      align: (left, right),                              // array of alignment
      stroke: 1.5pt + blue,                              // stroke (+ : length x color -> stroke)
      table.header([*Column 1*], [*Column 2*]),          // Content (until the end)
      [Cell 1], [Cell 2],
      table.cell(rowspan: 2, align: center)[Cell 3],
      table.cell(align: left)[Cell 4], [Cell 5],
    )
    ```,
  )
}

= It depends on the context

== `context`, content that depend on the location

=== Description

In typst, the content does not (usually) depend on its location in the document.

#pause

How to create location dependent content?

#pause

Example use cases:

- show the number of the current page

- using counters (for TeX users)

- have mutable global variables

#pause

=== Usage

```
#context { ... } : content -> content
```

Some functions MUST be included in `context` blocks.

== Counters

*Counters*: variables counting through pages, elements, and more.

In fact, it's just arrays of integers.

#pause

#typst-grid(
  ```typst
  #context {
    counter(heading).get()
  }
  ```,
)

#pause

#grid(
  columns: (1fr, 1fr),
  align: center + horizon,
  [
    #show raw: body => {
      show regex("(#|counter|\(|\)|heading|get|\.)"): word => underline(
        stroke: wave(
          amplitude: 1.5pt,
          stroke: 1pt + red,
        ),
        word,
      )
      body
    }
    ```typst
    #counter(heading).get()
    ```
  ],
  box(stroke: 1pt + black, inset: 5pt, radius: 5pt)[
    #set text(fill: red)
    #set align(left)

    error: can only be used when context is known
  ],
)

#pagebreak()

=== Display counters

#typst-grid(
  ```typst
  #context {
    counter(heading).display()
  }
  ```,
)

#typst-grid(
  ```typst
  #context {
    counter(heading).display("A.1)")
  }
  ```,
)

#pagebreak()

=== Updating counters

#typst-grid(cols: (2fr, 1fr), ```typst
#context { counter(page).get() }
#counter(page).step() \
#context { counter(page).get() }
#counter(page).update(n => n * 2) \
#context { counter(page).get() }
#counter(page).update(32) \
#context { counter(page).get() }
```)

#pause

#typst-grid(cols: (2fr, 1fr), ```typst
#context { counter(heading).get() }
#counter(heading).update((5, 2, 3)) \
#context { counter(heading).get() }
#counter(heading).step(level: 2) \
#context { counter(heading).get() }
```)

#counter(heading).update((2, 1))

#pagebreak()

== A consistent theory of time travel

#slide(title: [A consistent theory of time travel])[
  #typst-grid(
    ```typst
    #let foo = counter("foo")

    = Values
    #context [
      Value here: #foo.get() \
      At intro: #foo.at(<intro>) \
      Final value: #foo.final()
    ]
    #foo.update(n => n + 3)

    = Introduction <intro>
    #lorem(10)
    #foo.step()
    ```,
  )
]

== Extension to general variables

#grid(
  columns: (1fr, 1fr),
  column-gutter: 15pt,
  [
    #alternatives(
      [
        ```typst
        #let value = 5
        #let incr(nb) = {
          value = value + nb
        }
        #incr(1)
        ```
      ],
      [
        #show raw: body => {
          show "_": set text(size: 0pt)
          show "value_": underline(stroke: wave(
            amplitude: 1.5pt,
            stroke: 1pt + red,
          ))[value]
          body
        }
        ```typst
        #let value = 5
        #let incr(nb) = {
          value_ = value + nb
        }
        #incr(1)
        ```
      ],
    )
  ],
  only("2", box(inset: 5pt, stroke: 1pt + black, radius: 5pt)[
    #set text(fill: red)

    error: variables from outside the function are read-only and cannot be modified
  ]),
)

#pagebreak()

#typst-grid(
  ```typst
  #let foo = state("foo", 0)
  #let incr(nb) = {
    foo.update(n => n + nb)
  }
  #context { foo.get() }
  #incr(10) \
  #context { foo.get() }
  ```,
)

= Conclusion

== `typst` vs `LaTeX`

=== Pros

- Very simple syntax for simple things, and easier than `LaTeX` for complex ones
- Very good online documentation
- Human-understandable error messages
- Very fast incremental compilation
- Lots of community packages and templates (see #link("https://typst.app/universe"))
- No need for ```latex \expandafter``` or `expl3` syntax

=== Cons

Still in early development:
- Small breaking changes at each update (every ~6 monthes)
- Not as much StackOverflow pages as LaTeX
- Very few official templates
